<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.QPrintOptions" Title="<%$ Resources:Resource, VoxcoReporting%>" Theme="Voxco"  Codebehind="QPrintOptions.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
		<script type="text/javascript">
			function UpdateReportRequest()
			{
				$find("<%= MainAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= MainAjaxPanel.UniqueID %>", "UpdateReportRequest");
			}
			
			function CancelEventRowClick(sender, eventArgs)
			{		
				//Fix DE922
				return false;
			}
		</script>
    </telerik:RadScriptBlock>
    
    <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" >
        <VxRpt:WaitingPanel ID="WaitingPanel" runat="server" />
    </telerik:RadAjaxLoadingPanel>        
    
    <asp:ObjectDataSource ID="OptionsDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.QPrintOption" />
    <asp:ObjectDataSource ID="LanguagesDataSource" runat="server" OldValuesParameterFormatString="original_{0}" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.LanguagesDS"></asp:ObjectDataSource>
    
    <telerik:RadAjaxPanel ID="MainAjaxPanel" runat="server" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="MainAjaxPanel_OnAjaxRequest" Height="450px">
		<br />		        
		<div style="float: left; width: 30%; margin-right: 25px;">
			
			<asp:Label ID="panOptions" runat="server" Text="<%$ Resources:Resource, DisplayOptionsPan %>" CssClass="title" />
			<br />
			
			<telerik:RadGrid ID="grdOptions" runat="server" DataSourceID="OptionsDataSource" AutoGenerateColumns="False" AllowMultiRowSelection="true" 
			EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true" Height="400px">
				<MasterTableView DataSourceID="OptionsDataSource" GroupLoadMode="Client" Width="100%">
					<Columns>
						<telerik:GridClientSelectColumn UniqueName="Selected">
							<HeaderStyle Width="30px" HorizontalAlign="Left" />
							<ItemStyle Width="30px" HorizontalAlign="Left" />
						</telerik:GridClientSelectColumn>
						<telerik:GridBoundColumn UniqueName="OptionName" HeaderText="Name" DataField="QPrintOptionName" Display="False"></telerik:GridBoundColumn>
						<telerik:GridBoundColumn UniqueName="OptionText" HeaderText="<%$ Resources:Resource, SelectAll %>" DataField="QPrintOptionText">
							<HeaderStyle HorizontalAlign="Left" />
							<ItemStyle HorizontalAlign="Left" />
						</telerik:GridBoundColumn>										
					</Columns>
					<GroupHeaderItemStyle Font-Bold="true" />
					<GroupByExpressions>
						<telerik:GridGroupByExpression>									
							<SelectFields>
								<telerik:GridGroupByField FieldAlias="OptionTypeText" FieldName="QPrintOptionTypeText" HeaderText="&nbsp;" HeaderValueSeparator="" />
							</SelectFields>
							<GroupByFields>
								<telerik:GridGroupByField FieldName="QPrintOptionTypeID" FieldAlias="OptionTypeID" />
							</GroupByFields>
						</telerik:GridGroupByExpression>
					</GroupByExpressions>								
				</MasterTableView>
				<ClientSettings AllowGroupExpandCollapse="True">
					<Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True" />
					<Scrolling AllowScroll="True" UseStaticHeaders="True" />
				</ClientSettings>
			</telerik:RadGrid>

        </div>
                
        <div style="float: left; width: 30%; margin-right: 25px; height:385px;">
			<div class="frame" style="height: 400px;">
				<asp:Label ID="panAdditionalOpt" runat="server" Text="<%$ Resources:Resource, AdditionalOptionsPan %>" CssClass="title" />			
				<asp:CheckBoxList ID="chkAdditionalOptions" runat="server">
					<asp:ListItem Value="PrintScreens" Enabled="False" Text="<%$ Resources:Resource, PrintScreens %>"></asp:ListItem>
					<asp:ListItem Value="ReplaceINT">$R</asp:ListItem>
					<asp:ListItem Value="MatrixLines" Text="<%$ Resources:Resource, MatrixLines %>"></asp:ListItem>
					<asp:ListItem Value="Invalid" Enabled="False" Text="<%$ Resources:Resource, InvalidCodes %>"></asp:ListItem>
				</asp:CheckBoxList>
            </div>                
		</div>
              
		<div style="float: left; width: 30%;">
					
			<div class="frame" style="height: 400px;">
				<asp:Label ID="panStatistics" runat="server" Text="<%$ Resources:Resource, StatisticsPan %>" CssClass="title" />
				<br />
				<asp:CheckBoxList ID="chkStatisticsList" runat="server">
					<asp:ListItem Value="Frequencies" Text="<%$ Resources:Resource, Frequencies %>"></asp:ListItem>
					<asp:ListItem Value="Percentages" Text="<%$ Resources:Resource, Percentages %>"></asp:ListItem>
					<asp:ListItem Value="Mean" Text="<%$ Resources:Resource, Mean %>"></asp:ListItem>
					<asp:ListItem Value="StdDeviation" Text="<%$ Resources:Resource, StandardDeviation %>"></asp:ListItem>
					<asp:ListItem Value="TotalQuestionResponses" Text="<%$ Resources:Resource, QuestionTotal %>"></asp:ListItem>
				</asp:CheckBoxList>
			
				<div class="frame">
					
					<asp:Label ID="panElements" runat="server" Text="<%$ Resources:Resource, ElementsPan %>" CssClass="title" />
					<br />					
					<asp:RadioButtonList ID="optElements" runat="server">
						<asp:ListItem Value="CodesOnly" Selected="True" Text="<%$ Resources:Resource, CodesOnly %>"></asp:ListItem>
						<asp:ListItem Value="All" Text="<%$ Resources:Resource, AllElements %>"></asp:ListItem>
					</asp:RadioButtonList>
				</div>
				<div class="frame">	
					<asp:Label ID="panBase" runat="server" Text="<%$ Resources:Resource, Base %>" CssClass="title" />
					<br />
					<asp:RadioButtonList ID="optBase" runat="server">
						<asp:ListItem Selected="True" Text="<%$ Resources:Resource, ResponseBase %>" Value="Response"></asp:ListItem>
						<asp:ListItem Text="<%$ Resources:Resource, RespondentBase %>" Value="Respondent"></asp:ListItem>
					</asp:RadioButtonList>
					
				</div>	
			</div>		
		</div>
    </telerik:RadAjaxPanel>
</asp:Content>

